this.name			= "LongRangeScanner";
this.author			= "Captain Okti";
this.copyright		= "(C) 2010 Oktay Sarioglu";
this.licence			= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description	= "LongRangeScanner";
this.version			= "0.34.1";

this.activated = function()
{
	if(player.ship.equipmentStatus("EQ_LONG_RANGE_SCANNER") !== "EQUIPMENT_OK" || player.ship.docked) return;
	player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);
	timeAccelerationFactor = 0.0625;
	mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_Main"}, this.choice);
}

this.shipExitedWitchspace = function()
{
	if(missionVariables.lrangeScanner_LongRangeJump == "true") {
		if(system.ID == this.destinationSystem) {
			var Secs = clock.seconds;
			var TimeJumped = Secs - this.clockSeconds;
			var Days = Math.floor(TimeJumped/(24*3600));
			TimeJumped -= Days*24*3600;
			var Hours = Math.floor(TimeJumped/3600);
			TimeJumped -= Hours*3600;
			var Minutes = Math.floor(TimeJumped/60);
			player.commsMessage("You reached to "+System.systemNameForID(this.destinationSystem)+" In "+Days+" Days and "+Hours+" Hours and "+Minutes+" Minutes");
			missionVariables.lrangeScanner_LongRangeJump = null;
		} else this.JumpToDestination();
	}
}

this.JumpToDestination = function()
{
	player.ship.position = [1000000*(-1-Math.random()),1000000*(-1-Math.random()),1000000*(-1-Math.random())];
	var ship1 = system.addShips("EQ_MISSILE", 1, player.ship.position.add(player.ship.heading.multiply(130)), 0)[0];
	ship1.fuel = 7;
	if(!system.isInterstellarSpace) {
		var MyRoute = System.infoForSystem(galaxyNumber, system.ID).routeToSystem(System.infoForSystem(galaxyNumber, this.destinationSystem),missionVariables.lrangeScanner_jumpMethod);
		if(MyRoute.route.length > 0) {
			player.commsMessage("Jumping to : "+System.systemNameForID(MyRoute.route[1])+", "  +(MyRoute.route.length-1)+" more remains.",6);
			ship1.exitSystem(MyRoute.route[1]);
			missionVariables.lrangeScanner_LongRangeJump = true;
		}
	} else {
		player.commsMessage("Jumping to : Unkown sytem." ,6);
		ship1.fuel = 3.6;
		ship1.exitSystem();
		missionVariables.lrangeScanner_LongRangeJump = true;
	}
	timeAccelerationFactor = 1;
}

this.guiScreenChanged = function(to, from)
{
	if(player.ship.equipmentStatus("EQ_LONG_RANGE_SCANNER") !== "EQUIPMENT_OK" || player.ship.docked) return;
	if(to == "GUI_SCREEN_STATUS" && from == "GUI_SCREEN_LONG_RANGE_CHART") {
		player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);
		timeAccelerationFactor = 0.0625;
		if(player.ship.equipmentStatus("EQ_LONG_RANGE_SCANNER_JUMP") !== "EQUIPMENT_OK") mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_Main"}, this.choice)
		else mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_MainWithLRJ"}, this.choice);
	}
}

this.missionScreenEnded = function()
{
	timeAccelerationFactor = 1;
}
this.DisplaySystemInfo = function()
{
	if(!system.isInterstellarSpace) {
		mission.runScreen({title:"Jump Planner", choicesKey:"lRangeScanner_Jump_Main"}, this.choice);
		this.destinationSystem = player.ship.targetSystem;
		mission.addMessageText("Your Targeted system is: "+System.systemNameForID(player.ship.targetSystem)+"(SystemID = "+player.ship.targetSystem+"), Coordinates = "+(Math.floor(System.infoForSystem(galaxyNumber,this.destinationSystem).coordinates.x*100)/100)+","+(Math.floor(System.infoForSystem(galaxyNumber,this.destinationSystem).coordinates.y*100)/100));
		mission.addMessageText("");
		var MyRoute = system.info.routeToSystem(System.infoForSystem(galaxyNumber,this.destinationSystem), "OPTIMIZED_BY_TIME");
		var MyRouteJ = system.info.routeToSystem(System.infoForSystem(galaxyNumber,this.destinationSystem), "OPTIMIZED_BY_JUMPS");
		if(MyRoute.route === null) {
			var MyRoute = 9;
			var MyRouteJ = 7;
		}
		var Sys1 ="";
		var i = 1;
		for(i=1;i<MyRoute.route.length;i++)
		{
			Sys1 += System.systemNameForID(MyRoute.route[i])+", ";
		}
		mission.addMessageText("Systems To Jump for minimum Jump Time are "+Sys1+" Total of "+(MyRoute.route.length-1)+" Jumps, Total "+(Math.floor(MyRoute.distance*100)/100)+" LY's, in "+(Math.floor(MyRoute.time*100)/100)+" Hours");
		mission.addMessageText("");
		var Sys2 ="";
		for(i=1;i<MyRouteJ.route.length;i++)
		{
			Sys2 += System.systemNameForID(MyRouteJ.route[i])+", ";
		}
		mission.addMessageText("Systems To Jump for minimum Jump Count are "+Sys2+" Total of "+(MyRouteJ.route.length-1)+" Jumps, Total "+(Math.floor(MyRouteJ.distance*100)/100)+" LY's, in "+(Math.floor(MyRouteJ.time*100)/100)+" Hours");
		mission.addMessageText("")
		mission.addMessageText("Coordinates ="+player.ship.galaxyCoordinates.x+" , "+ player.ship.galaxyCoordinates.y)
	} else {
		mission.runScreen({title:"Jump Planner", choicesKey:"lRangeScanner_Jump_Main"}, this.choice);
		this.destinationSystem = player.ship.targetSystem;
		mission.addMessageText("Your Targeted system is: "+System.systemNameForID(player.ship.targetSystem)+"(SystemID = "+player.ship.targetSystem+")");
		mission.addMessageText("");
		mission.addMessageText("Currently you are in witchspace");
		mission.addMessageText("");
		mission.addMessageText("Coordinates ="+player.ship.galaxyCoordinates.x+" , "+ player.ship.galaxyCoordinates.y);
	}
}
this.choice = function(choice)
{
	switch(choice)
	{
		case "Main_02": {
			missionVariables.lrangeScanner_action = 1;
			missionVariables.lrangeScanner_start = 1;
			player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);
			this.displayScr1();
			break; }
		case "Main_04": { this.DisplaySystemInfo(); break; }
		case "Main_03": {
			missionVariables.lrangeScanner_action = 2;
			missionVariables.lrangeScanner_start = 1;
			player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);
			this.displayScr1();
			break; }
		case "Jump_01": {
			if(system.ID != player.ship.targetSystem) {
				this.clockSeconds = clock.seconds;
				missionVariables.lrangeScanner_jumpMethod = "OPTIMIZED_BY_TIME";
				this.JumpToDestination();
			}
			break; }
		case "Jump_02": {
			if(system.ID != player.ship.targetSystem) {
				this.clockSeconds = clock.seconds;
				missionVariables.lrangeScanner_jumpMethod = "OPTIMIZED_BY_JUMPS";
				this.JumpToDestination();
			}
			break; }
		case "SCANNER_01": { lrscnr = 0; this.scanner(); break; }
		case "SCANNER_02": { lrscnr = 1; this.scanner(); break; }
		case "SCANNER_03": { lrscnr = 2; this.scanner(); break; }
		case "SCANNER_04": { lrscnr = 3; this.scanner(); break; }
		case "SCANNER_05": { lrscnr = 4; this.scanner(); break; }
		case "SCANNER_06": { lrscnr = 5; this.scanner(); break; }
		case "SCANNER_07": { lrscnr = 6; this.scanner(); break; }
		case "SCANNER_08": { lrscnr = 7; this.scanner(); break; }
		case "SCANNER_09": { lrscnr = 8; this.scanner(); break; }
		case "SCANNER_10": { lrscnr = 9; this.scanner(); break; }
		case "SCANNER_11": { lrscnr = 10; this.scanner(); break; }
		case "SCANNER_12": { lrscnr = 11; this.scanner(); break; }
		case "SCANNER_13": { lrscnr = 12; this.scanner(); break; }
		case "SCANNER_14": { lrscnr = 13; this.scanner(); break; }
		case "SCANNER_15": { lrscnr = 14; this.scanner(); break; }
		case "SCANNER_16": { lrscnr = 15; this.scanner(); break; }
		case "SCANNER_17": { lrscnr = 16; this.scanner(); break; }
		case "SCANNER_18": { lrscnr = 17; this.scanner(); break; }
		case "SCANNER_50_EXIT": {
			missionVariables.lrangeScanner_start = missionVariables.lrangeScanner_start+18;
			displayScr1();
			break; }
		case "SCANNER_99_EXIT": { timeAccelerationFactor = 1; break; }
		case "Main_99_EXIT": { timeAccelerationFactor = 1; break; }
		case "Main_01": {
			if(system.isInterstellarSpace || system.sun.isGoingNova || system.sun.hasGoneNova) break;
			player.ship.position = system.mainStation.position.subtract([(Math.random()*10000),(Math.random()*10000),(Math.random()*10000)]);
			var targetVector = system.mainStation.position.subtract(player.ship.position).direction();
			var angle = player.ship.heading.angleTo(targetVector);
			var cross = player.ship.heading.cross(targetVector).direction();
			player.ship.orientation = player.ship.orientation.rotate(cross,-angle);
			timeAccelerationFactor = 1;
			break; }
		default: { timeAccelerationFactor = 1; break; }
	}
}
this.scanner = function()
{
	timeAccelerationFactor = 1;
	if(missionVariables.lrangeScanner_action == 1) {
		if(!missionVariables.lrangeScanner_start) missionVariables.lrangeScanner_start = 0;
		if(!lrscnr) lrscnr = 0;
		player.ship.target = system.allShips[missionVariables.lrangeScanner_start+lrscnr];
	} else {
		player.ship.position=system.allShips[missionVariables.lrangeScanner_start+lrscnr].position.subtract([(Math.random()*10000),(Math.random()*10000),(Math.random()*10000)]);
	}
	var targetVector = system.allShips[missionVariables.lrangeScanner_start+lrscnr].position.subtract(player.ship.position).direction();
	var angle = player.ship.heading.angleTo(targetVector);
	var cross = player.ship.heading.cross(targetVector).direction();
	player.ship.orientation = player.ship.orientation.rotate(cross,-angle);
}
this.displayScr1 = function()
{
	var shps = new Array();
	var i = 0;
	while(i <= system.allShips.length-1)
	{
		shps[i] = system.allShips[i];
		if(!system.allShips[i].isRock && !system.allShips[i].isThargoid && !system.allShips[i].isCargo) {
			if(system.allShips[i].bounty > 0) {
				system.allShips[i].scannerDisplayColor1 = "redColor";
				system.allShips[i].scannerDisplayColor2 = "yellowColor";
			}
		}
		i ++;
	}
	timeAccelerationFactor = 0.0625;
	var EndIX = system.allShips.length-1;
	var j = missionVariables.lrangeScanner_start;
	var EndI = j+17;
	if(system.allShips.length > 17) {
		if(EndI > EndIX) {
			EndI=EndIX;
		}
	} else EndI = system.allShips.length-1;
		var counter = 1;
		while(j <= EndI)
	{
		var psp = player.ship.position;
		var x = (j)+"-"+shps[j].displayName+" - Bounty("+shps[j].bounty+") Distance "+(Math.round(shps[j].position.distanceTo(psp)));
		if(counter == 1) missionVariables.lrangeScanner_01 = x;
		if(counter == 2) missionVariables.lrangeScanner_02 = x;
		if(counter == 3) missionVariables.lrangeScanner_03 = x;
		if(counter == 4) missionVariables.lrangeScanner_04 = x;
		if(counter == 5) missionVariables.lrangeScanner_05 = x;
		if(counter == 6) missionVariables.lrangeScanner_06 = x;
		if(counter == 7) missionVariables.lrangeScanner_07 = x;
		if(counter == 8) missionVariables.lrangeScanner_08 = x;
		if(counter == 9) missionVariables.lrangeScanner_09 = x;
		if(counter == 10) missionVariables.lrangeScanner_10 = x;
		if(counter == 11) missionVariables.lrangeScanner_11 = x;
		if(counter == 12) missionVariables.lrangeScanner_12 = x;
		if(counter == 13) missionVariables.lrangeScanner_13 = x;
		if(counter == 14) missionVariables.lrangeScanner_14 = x;
		if(counter == 15) missionVariables.lrangeScanner_15 = x;
		if(counter == 16) missionVariables.lrangeScanner_16 = x;
		if(counter == 17) missionVariables.lrangeScanner_17 = x;
		if(counter == 18) missionVariables.lrangeScanner_18 = x;
		j ++;
		counter ++;
	}
	if(counter > 17) mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice"}, this.choice)
	else switch(counter)
	{
	case 2: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_01"}, this.choice); break; }
	case 3: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_02"}, this.choice); break; }
	case 4: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_03"}, this.choice); break; }
	case 5: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_04"}, this.choice); break; }
	case 6: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_05"}, this.choice); break; }
	case 7: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_06"}, this.choice); break; }
	case 8: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_07"}, this.choice); break; }
	case 9: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_08"}, this.choice); break; }
	case 10: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_09"}, this.choice); break; }
	case 11: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_10"}, this.choice); break; }
	case 12: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_11"}, this.choice); break; }
	case 13: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_12"}, this.choice); break; }
	case 14: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_13"}, this.choice); break; }
	case 15: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_14"}, this.choice); break; }
	case 16: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_15"}, this.choice); break; }
	case 17: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_16"}, this.choice); break; }
	case 18: {mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:"lRangeScanner_choice_17"}, this.choice); break; }
	}
}